#include "franca2001.h"
#include "math.h"
class Screen:public Stage
{
public:
	void turn(float howmanydegrees);
   void resize(float vsize,float hsize=0);
   void color(int fill,int contour=0);
   void zoom(float factor);
};
void Screen::turn(float howmanydegrees)
{
	float radians;
	float x1,y1,radius,alpha;
	radians=howmanydegrees*3.14159/180.;
	for(int i=0;i<currobj;i++)
	{
        x1=cast[i]->x-x;
		  y1=cast[i]->y-y;
	     alpha=atan((y1)/(x1));
		  if(x1<0) alpha=alpha+3.14159;
		  radius=sqrt((x1)*(x1)+(y1)*(y1));
        cast[i]->x=radius*cos(alpha+radians)+x;
		  cast[i]->y=radius*sin(alpha+radians)+y;
	}
}
void Screen::resize(float vsize,float hsize)
{
    float newv,newh;
    if(hsize==0) hsize=vsize;
    for(int i=0;i<currobj;i++)
    {
        newv=cast[i]->size*vsize;
        newh=cast[i]->lenght*hsize;
        cast[i]->resize(newv,newh);
    }
}
void Screen::color(int fill,int contour)
{
    for(int i=0;i<currobj;i++)
    {
       cast[i]->color(fill,contour);
    }
}
void Screen::zoom(float factor)
{
   float x1,y1,radius,alpha;
	for(int i=0;i<currobj;i++)
	{
        x1=cast[i]->x-x;
		y1=cast[i]->y-y;
	    alpha=atan((y1)/(x1));
		if(x1<0) alpha=alpha+3.14159;
		radius=sqrt((x1)*(x1)+(y1)*(y1));
        cast[i]->x=factor*radius*cos(alpha)+x;
		cast[i]->y=factor*radius*sin(alpha)+y;
	}
	resize(factor);
}
