// Updated Feb 22nd, 2001
//       accepts C++ string classes
//       box.say(string something);
//       string name=askwords(question);
// updated Nov, 22nd, 1997:
//         feb 1998
// This header incorporates the interface to:
//   the utility functions
//       sound
//       soundgo
//       yesno
//       ask
//   as well as the classes:
//       clock
//       canvas and screen objects
//       athletes (as derived from Stages)
//   May, 24, 1995
//
//  Note:
//  The user version of franca.h may have the
//      references to some include files removed...
//
#include <stdlib.h>
#ifdef _STRING_
#define __CSTRING_H
#endif
#ifndef _CANVAS_H
#define _CANVAS_H
#define WINVER 0X030A
//#include <windows.h>     // not needed for users
//#include <mmsystem.h>    // not needed for users
// this typedef must be included to if "winuser.h" is used
// ************************
//typedef NMHDR FAR * LPNMHDR;
// ************************
int extern sound(char * soundname);
int extern soundgo (char * soundname);
int extern yesno (char * question);
float extern ask(char *);
void askwords(char *where,int maxsize,char *question);
//
class Clock //***************************  Clock
{
   protected:
    long timestarted;
   public:
    Clock();
    float time();     	// returns the time elapsed sec
    void wait(float tsec);// wait tsec seconds
    void watch(float set);// wait until time=set
    void reset();  	// resets 
};

// This class set manages screen activities:
//   here is the class hierarchy:
//
//          canvas (has tools to draw)
//           /
//          /
//    ScreenObj   (represents one object on screen)
//     /   / /|
// Grid  /  / |
//    stage/  |   (handles several objects; special instance-> opera)
//        /   |    ( all objects inserted in a given stage can be shown
//       /    |      with a simple message show() to the stage)
//      /     |
//     /     box  (an object specialized to contain a small text) 
//  circle
//  square
//
class canvas
{
 public:
   canvas();
  ~canvas();
  //void validatedc(HDC adc); //not needed for users
  void pickbrush(int );
  void pickpen(int );
  void rectangle(float ,float,float,float);
  void ellipse(float,float,float,float);
  void text(float,float,char *,int);
  void test(char *);
  void test(int );
  void pixel(float,float,int);
};

//		       ************************* ScreenObj
class ScreenObj:public canvas
{
 //protected:
 friend class Stage;
 friend class Screen;
 protected:
  float x,y,z;
  int colorbrush,colorpen;
  float size,lenght;
 public:
  virtual void show();
  virtual void place(float x1,float y1,float z1);
  virtual void place(float x1,float y1);
  virtual void erase();
  virtual void resize(float newsize, float newlen=0.);
  virtual void color(int brush,int pen=0);// default pen is white
  virtual void scale(float, float);
  virtual void absize(float newsize,float newlen=0.);
  virtual void timescale(float time);
  virtual void origin(float x0,float y0);
  ScreenObj();
};
//			************************** Stage
class Stage:public ScreenObj
{
 protected:
  int maxobj,currobj;
  ScreenObj *cast[50];  //cast holds pointers to each object
 public:
  Stage();
  Stage(Stage &hall);
  void resize(float horiz,float vert=0);
  void insert(ScreenObj *);
  void insert(ScreenObj &);
  void operator<<(ScreenObj *);
  void operator<<(ScreenObj &);
  virtual void place (float, float, float );
  virtual void place (float,float);
  virtual void show();
  virtual void erase();
};
const int maxchars=101,lettersize=18;
const int stdlenght=140,stdheight=40;
//
// ******************************************     box
char emptystr[]="";
class box: public ScreenObj
{
  protected:
	char title[maxchars+1];
	char message[maxchars+1];
  protected:
	int lenght,height;  	// lenght,height of box in pixels
	int size(char *);
	void copy(char *,char*);
  public:
	box(float x1,float y1,char *name=emptystr,int l=stdlenght,int h=stdheight);
	box(char *name=emptystr);  
	void show();
	void say(int number);
	void say(char *);
	void say(float number);
// support for string
#ifdef __CSTRING_H
   void say(string);
#endif
//
	void label(char *);
	void label(int);
	void erase();
};
#ifdef __CSTRING_H
void box::say(string  something)
{
   char thetext[100];
   strcpy(thetext,something.c_str());
   say(thetext);
}
string askwords(char question[])
{
    char words[100];
    askwords(words,100,question);
    return (string) words;
}
#endif
class Stringbox:public box
{
	 friend class inbox;
	// This box is special to display strings
	 public:
	 Stringbox();
	 Stringbox(char *name);
	 void operator<<(char *);
	 void operator<<(int);
	 void operator<<(float);
};
class saybox: public box
{
	public:
	 void show();
};

class square:public ScreenObj
{
	public:
	square(float x1=0,float y1=0,float z1=0);
	void show();
	void erase();
};

class Circle: public ScreenObj
{
	protected:
	public:
	  Circle(float x1=0,float y1=0,float z1=0);
	  void show();
	  void erase();
};
class Grid:public ScreenObj
{
	public:
	Grid(float x0=50.,float y0=400.,float xscale=1.,float yscale=-1.);
	void show();
	void erase();
};
typedef box Box;
typedef square Square;

//  static int rowcall=0;  // not needed for users
  static const int maxcolmn=8;		// athletes/column
  static const int squaresize=60;//60;
  static const int armsize=20;
  static const int armwidth=6;
  static const int dialogsize=25;
  static const int maxrow=8,maxatl=32;
class inbox
{
  char message[100];
  public:                           
  inbox();
  void operator>>(float &);
  void operator>>(char *);
};

class athlete: public Stage
{
  int jogstatus;
 protected:
  Circle head;
  Square trunk;
  Clock swiss;
  Square leftleg,rightleg;
  Square leftarm,rightarm;
  saybox speech;
 private:
  void prepare(int,int);
  void setshape();
 public:
  athlete();
  athlete(athlete&);
  athlete(int,int);
  void ready(float time=1.);
  void up(float time=1.);
  void left(float time=1.);
  void right(float time=1.);
  void say(float);
  void say(char *);
  void say(int);
  int ask(char *);
};
const int mxrows=14,mxcols=16;
typedef int looklike[mxcols][mxrows];
void moveto(ScreenObj &,int x,int y);
class Robot: public athlete
{
  Clock titan;
  Box message;
  looklike realmaze,knownmaze,mazeshape;
  int direction,tracerx,tracery;
  int rows,cols;
  Square tile;
  //fstream mazefile;
  void next(int &x,int &y);
  void turn();
  void showtracer();
  void make();

 public:
  Robot();
  Robot(int);
  void crash();
  void left();
  void right();
  int seewall();
  int seenowall();
  void step(int i=1);
  void face(int);
  void say(char * sentence);
  void say(int number);
  void mark(int color=2);
  void timescale(float t);
};
Stringbox Cout;
inbox Cin;
#endif

// end

 
