#include "franca.h" // c52001.cpp 
#include <math.h> 
const float pi=3.14159; 
void polarxy(float r,float teta,float x0, 
float y0,float &x,float &y) 
{ 
     x=r*cos(teta)+x0; 
     y=r*sin(teta)+y0; 
} 
void mainprog() 
{ 
     const float earthradius=160.,moonradius=40.; 
     const float earthsize= 30., moonsize=16., sunsize = 80.; 
     Stage universe; 
     universe.origin(240.,240.); 
     universe.scale(1.,-1.); 
     Square sky; 
     sky.place(80,0); 
     sky.resize(480,640); 
     sky.color(7,7); 
       
     // set Sun's data: 
     Circle sun; // declare sun shape 
     float xsun=0,ysun=0; // initial coordinates; 
     sun.resize(sunsize); 
     sun.color(6,6); 
     sun.place(xsun,ysun); 
     universe.insert(sun); 
     // set Earth's data: 
     Circle earth; // declare earth's shape 
     float xearth=earthradius,yearth=0.; // initial coordinates 
     float wearth=(2*pi)/365.25;// angular speed radians per day 
     earth.resize(earthsize); 
     earth.color(4,4); 
     earth.place(xsun+earthradius,ysun); 
     universe.insert(earth); 
     // set moon's data: 
     Circle moon; 
     float xmoon=moonradius,ymoon=0; 
     float wmoon=(2*pi)/27.; // angular speed 
     moon.resize(moonsize); 
     moon.color(0,0); 
     moon.place(xsun+earthradius+moonradius,ysun); 
     universe.insert(moon); 
     // Special effects: 
     sky.show(); 
     Circle light; 
     light.place(0,0); 
     light.color(3,3); 
     light.resize(2); 
     int grow=2; 
     for (;grow<=480;grow++) 
     { 
          Clock timer; 
          light.resize(grow); 
          sun.resize(grow/6); 
          light.show(); 
          sun.show(); 
          timer.watch(0.03); 
          timer.reset(); 
     } 
     //sky.place(80,0); 
     //sky.resize(480,640); 
     sky.color(3,3); 
     sky.show(); 
     //universe.insert(sky); 
     // 
       
     //float orbitradius,angle,lastframetime; 
     float time,timescale=10.; 
     Box day("Day:"); 
     Clock sideral; 
     Clock stopwatch; 
     time=sideral.time()*timescale; 
     sound("zaratust.wav");
	  for (;time<365.25;)
     { 
          //universe.erase(); 
          //sky.show(); 
          polarxy(earthradius,wearth*time,xsun,ysun,xearth,yearth); 
          earth.place(xearth,yearth); 
          polarxy(moonradius,wmoon*time,xearth,yearth,xmoon,ymoon); 
          moon.place(xmoon,ymoon); 
          //day.say(time); 
          sky.show(); 
          universe.show(); 
          stopwatch.watch(.033); 
          stopwatch.reset(); 
          time=sideral.time()*timescale; 
     } 
} 