#include "franca.h"
#include <math.h>
const float g=32.18;		// Gravity
// Functions to compute coordinates:
float dist(float velocx,float t)
{
   return velocx*t;
}
float height(float velocy,float t)
{
   return velocy*t - 0.5 * g * t * t;
}

void mainprog()           // part 1
{
  Grid mygrid;
  mygrid.origin(50.,420);
  mygrid.scale(400./30000,-400./30000);
  // Declare and label boxes for displaying
  // x, y and time.
  Box boxx("x:"),boxy("y:"),boxt("Time:");
  Box vx("Vx:"),vy("Vy:");
  mygrid.resize(30000.);
  mygrid.show();	// Show axes
  float t; // t is the time
  Circle body; // Declare the body 
  body.absize(10.); // size it 
  body.color(3,3); // and color it.
  Clock timer; // Declare a timer clock
  Clock watch; // Declare another clock 
  float teta,veloc,velx,vely;
  //   Request data 
  teta=ask("Enter angle of firing:");
  teta=teta*3.14159/180.; // convert to radians
  veloc=ask("Enter initial velocity:");
  velx=veloc*cos(teta);// decompose into x and y
  vely=veloc*sin(teta);
  vx.say(velx);
  vy.say(vely);
 float x,y;      //c5cannon.cpp   part - 2
 // The loop below will be repeated
 // as long as the time is less than 15 seconds
 // note that current time is copied into
 // the variable "t"
 timer.reset();
 watch.reset();
 while ((t=watch.time())<50.)
 {
   y=height(vely,t);
   if (y<0) break;
   x=dist(velx,t);
   boxx.say(x); // Update value of x, y 
   boxy.say(y); // and time in the 
   boxt.say(t); // appropriate boxes.
   body.erase();
   body.place(x,y); // Place body in current location 
   body.show(); // Show the body
   timer.watch(.033); // wait till timer reaches 
   timer.reset(); // .033 secs and reset
 }
}
