
#include "franca.h"
// choose either
//#define Microsoft
// or 
// #define Borland
// this version updated to support both compilers.
#include "c8tfile.h"
#include <string.h>
#include <fstream.h>
typedef char words[9];

class jukebox
{
   protected:  
     char directory[30],filename[40];
     int wordnumber;
     words list[40];
     void whatfile(words name); //generates filename
   public:
     int howmanywords();
     void pronounce(words thisword);
     void pronounce(int whichword);
     void spell(int which,words spelled);
     jukebox(char path[]);
     jukebox();
     int find(words whichone);
};
jukebox::jukebox()
{
    wordnumber=0;
    directory[0]=0;
}
jukebox::jukebox(char path[])
{
     fstream wordlist;
     if(strlen(directory)>30)directory[0]=0;
     strcpy(directory,path); //directory
     strcpy(filename,directory);
     strcat(filename,"list");
     strcat(filename,".txt");
     wordlist.open(filename,ios::in|ios::nocreate);//filename
	  if(fileopen(wordlist)==0)
     {              // check if file available
		 Box errormsg("Error:");
		 errormsg.say("No List!");
		 exit(0);
	  }
	  for (int k=0;k<100;k++)
	  {              //read words
		  if(wordlist.eof()) break;
		  wordlist>>list[k];
	  }
	  wordnumber=k;  //number of words
}
int jukebox::howmanywords()
{
	return wordnumber;
}
void jukebox::spell(int which,words spelled)
{
	  if (which>=wordnumber)
	  {
		 strcpy(spelled,""); // restrict size!
		 return;
	  }
	  strcpy(spelled,list[which]);// copy to spelled
}
void jukebox::whatfile(words list)
{
	strcpy(filename,directory);   // prefix
	strcat(filename,list);        // name
	strcat(filename,".wav");      // suffix
}
void jukebox::pronounce(int whichword)
{
	whatfile(list[whichword]);
	sound(filename);
}
void jukebox::pronounce(words thisword)
{
	whatfile(thisword);
	sound(filename);
}
class bank
{
  protected:
	Circle greencoin,redcoin;
	float xgreen,xred;
	float nextygreen,nextyred;
  public:
	void plus();
	void minus();
	bank(float x=50,float y=400);
};
class teacher
{
  bank FirstNational;
  Box yourword;
  Clock myclock;
  Box plus,minus;
  jukebox speaker;
  int right,wrong;
  public:
	void playlist();
	void test();
	teacher(jukebox &neon);
};
teacher::teacher(jukebox &neon)
{
  speaker=neon; //copy to teacher's jukebox
  right=wrong=0;
  plus.label("Right:");
  plus.say(right);
  minus.label("Wrong:");
  minus.say(wrong);
}
void teacher::playlist()
{
  words oneword;
  int n=speaker.howmanywords();
  for (int k=0;k<n;k++)
	{
	  speaker.spell(k,oneword);
	  yourword.say(oneword);
	  speaker.pronounce(k);
	  myclock.wait(2);
	  yourword.erase();
	}
}
void teacher::test()
{
  char spelling[20];  //student's word
  char correct[20];   //correct word
  int j;
  int count=2*speaker.howmanywords();//number of questions
  for(int k=1;k<=count;k++)
  {
	 j=rand()%speaker.howmanywords();
	 strcpy(spelling,"");             //clear display
	 speaker.pronounce(j);
	 askwords(spelling,9,"Please spell:");
	 speaker.spell(j,correct);
	 if(stricmp(spelling,correct)==0)
	 {
		 speaker.pronounce("allright");
		 plus.say(++right);
		 FirstNational.plus();
	 }
	 else
	 {
		 yesno(" Wrong! Will you study harder?");
		 minus.say(++wrong);
		 FirstNational.minus();
	 }
  }
}
bank::bank(float x,float y)
{
	xgreen=x;
	xred=x+50;
	nextygreen=y;
	nextyred=y;
	greencoin.resize(20,40);
	greencoin.color(2,7);
	redcoin.resize(20,40);
	redcoin.color(1,7);
}
void bank::plus()
{
	greencoin.place(xgreen,nextygreen);
	greencoin.show();
	nextygreen=nextygreen-10;
}
void bank::minus()
{
	redcoin.place(xred,nextyred);
	redcoin.show();
	nextyred=nextyred-10;
}
void mainprog()
{
	jukebox speaker("sounds\\");
	teacher MrRoberts(speaker);
	MrRoberts.playlist();
	MrRoberts.test();
	speaker.pronounce("allright");
	speaker.pronounce("byebye");
}